// Example 303
// モーター回転方向
//  前進: LOW
//  後退: HIGH

const int MOTOR_R_CWCCW = 7;
const int MOTOR_L_CWCCW = 8;
const int MOTOR_R_PWM = 9;
const int MOTOR_L_PWM = 10;
const int sp=100;

void motor(int left, int right, int left_c, int right_c) {
  if (left_c == LOW) {
    digitalWrite(MOTOR_L_CWCCW, LOW); // 左回転方向（前進）
  } else {
    digitalWrite(MOTOR_L_CWCCW, HIGH); // 左回転方向（後退）
  }
  if (right_c == LOW) {
    digitalWrite(MOTOR_R_CWCCW, LOW); // 右回転方向（前進）
  } else {
    digitalWrite(MOTOR_R_CWCCW, HIGH); // 右回転方向（後退）
  }
  analogWrite(MOTOR_L_PWM, right); // 左PWM(0 -255)
  analogWrite(MOTOR_R_PWM, left); // 右PWM(0 -255)
}

void fwd(int tau){
  motor(sp, sp, LOW, LOW);
  delay(tau);
}

void bwd(int tau){
  motor(sp, sp, HIGH, HIGH);
  delay(tau);  
}

void stp(int tau){
  motor(0, 0, LOW, LOW);
  delay(tau);
}

void rotL(int tau){
  motor(sp, sp, HIGH, LOW);  //  右回転
  delay(1000); 
}

void rotR(int tau){
  motor(sp, sp, LOW, HIGH);  //  右回転
  delay(tau);
}

void setup() {
  pinMode(MOTOR_L_CWCCW, OUTPUT); // 左回転方向
  pinMode(MOTOR_R_CWCCW, OUTPUT); // 右回転方向
}

void loop() {
  int tau=1000;
  
  fwd(tau);
  stp(tau);
  bwd(tau);
  stp(tau);
  rotL(tau);
  stp(tau);
  rotR(tau);
  stp(tau);
}

