// Example 301: same as Example 104a
// モーター回転方向
//  前進: LOW
//  後退: HIGH

const int MOTOR_R_CWCCW = 7;
const int MOTOR_L_CWCCW = 8;
const int MOTOR_R_PWM = 9;
const int MOTOR_L_PWM = 10;

void motor(int left, int right, int left_c, int right_c) {
  if (left_c == LOW) {
    digitalWrite(MOTOR_L_CWCCW, LOW); // 左回転方向（前進）
  } else {
    digitalWrite(MOTOR_L_CWCCW, HIGH); // 左回転方向（後退）
  }
  if (right_c == LOW) {
    digitalWrite(MOTOR_R_CWCCW, LOW); // 右回転方向（前進）
  } else {
    digitalWrite(MOTOR_R_CWCCW, HIGH); // 右回転方向（後退）
  }
  analogWrite(MOTOR_L_PWM, right); // 左PWM(0 -255)
  analogWrite(MOTOR_R_PWM, left); // 右PWM(0 -255)
}

void setup() {
  pinMode(MOTOR_L_CWCCW, OUTPUT); // 左回転方向
  pinMode(MOTOR_R_CWCCW, OUTPUT); // 右回転方向
}

void loop() {
  motor(100, 100, LOW, LOW);  // LOW:前進
  delay(1000);// LOW:forward :fwd()
  motor(100, 100, HIGH, HIGH);// HIGH:後退
  delay(1000);// HIGH:backward :bwd()
}

