// Example 302
// モーター回転方向
//  前進: LOW
//  後退: HIGH

const int MOTOR_R_CWCCW = 7;
const int MOTOR_L_CWCCW = 8;
const int MOTOR_R_PWM = 9;
const int MOTOR_L_PWM = 10;
const int sp=100;

void motor(int left, int right, int left_c, int right_c) {
  if (left_c == LOW) {
    digitalWrite(MOTOR_L_CWCCW, LOW); // 左モーターを前進方向に回す
  } else {
    digitalWrite(MOTOR_L_CWCCW, HIGH); // 左モーターを後退方向に回す
  }
  if (right_c == LOW) {
    digitalWrite(MOTOR_R_CWCCW, LOW); // 右モーターを前進方向に回す
  } else {
    digitalWrite(MOTOR_R_CWCCW, HIGH); // 右モーターを後退方向に回す
  }
  analogWrite(MOTOR_L_PWM, right);// 左モーターの回転速度(0-255)
  analogWrite(MOTOR_R_PWM, left); // 右モーターの回転速度(0-255)
}

void setup() {
  pinMode(MOTOR_L_CWCCW, OUTPUT); // 左回転方向
  pinMode(MOTOR_R_CWCCW, OUTPUT); // 右回転方向
}

void loop() {
  int tau=2000;
  
  motor(sp, sp, HIGH, LOW);  //  左回転
  delay(tau);// rotation to Left: rotL()
  motor(0, 0, HIGH, LOW);  //  停止
  delay(tau);// stop()
  motor(sp, sp, LOW, HIGH);  //  右回転
  delay(tau);// rotation to Right: rotR()
  motor(0, 0, HIGH, LOW);  //  停止
  delay(tau);
}

