// Example 301a
// モーター回転方向
//  前進: LOW
//  後退: HIGH

const int MOTOR_R_CWCCW = 7;
const int MOTOR_L_CWCCW = 8;
const int MOTOR_R_PWM = 9;
const int MOTOR_L_PWM = 10;
const int sp=100;

void motor(int left, int right, int left_c, int right_c) {
  if (left_c == LOW) {
    digitalWrite(MOTOR_L_CWCCW, LOW);
  } else {
    digitalWrite(MOTOR_L_CWCCW, HIGH);
  }
  if (right_c == LOW) {
    digitalWrite(MOTOR_R_CWCCW, LOW);
  } else {
    digitalWrite(MOTOR_R_CWCCW, HIGH);
  }
  analogWrite(MOTOR_L_PWM, right);
  analogWrite(MOTOR_R_PWM, left);
}

void fwd(float cm){
  int tau;
  
  motor(sp, sp, LOW, LOW);
  tau = 2500.0*cm/20.0;
  delay(tau);  
}

void bwd(float cm){
  int tau;
  
  motor(sp, sp, HIGH, HIGH);
  tau = 2500.0*cm/20.0;
  delay(tau);  
}

void stp(int tau){
  motor(0, 0, LOW, LOW);
  delay(tau);  
}

void rotL(float deg){
  int tau;
  motor(sp, sp, HIGH, LOW);
  tau = 3780.0*deg/360.0;
  delay(tau);  
}

void rotR(float deg){
  int tau;
  motor(sp, sp, LOW, HIGH);
  tau = 3820.0*deg/360.0;
  delay(tau);  
}

void setup() {
  pinMode(MOTOR_L_CWCCW, OUTPUT);
  pinMode(MOTOR_R_CWCCW, OUTPUT);
}

void loop() {
  fwd(10.0); // forward to 10.0 cm
  rotL(90.0);// turn to 90.0 degree
  stp(1000); // stop 1000 mili-seconds
}

