// Example0402a
void setup() {
  Serial.begin(38400); // bps for bluetooth communication
  Serial.flush(); // flush serial buffer
}
void loop() {
  int sensorValue = analogRead(A3); // read value from distance sensor
  float dist = 322549.9 * pow(sensorValue, -1.25356); // calcurate distance [mm]
  float dist_n = lpf_rc(dist);
  Serial.println(dist_n);
  delay(50);  // should wait 50ms for update the data
}

// ノイズ除去：RCフィルタ
// aの値を大きくするとノイズ除去効果大
// ただし、減衰し位相も遅れる
float lpf_rc(float d) {
  static float y_p; // 計算結果, 一つ前の値
  float a = 0.9; // 0.0 < a < 1.0
  float y = a * y_p + (1.0 - a) * d;
  y_p = y;
  return y;
}

