// Example0402b
void setup() {
  Serial.begin(38400); // bps for bluetooth communication
  Serial.flush(); // flush serial buffer
}
void loop() {
  int sensorValue = analogRead(A3); // read value from distance sensor
  float dist = 322549.9 * pow(sensorValue, -1.25356); // calcurate distance [mm]
  float dist_n = lpf_avg(dist);
  Serial.println(dist_n);
  delay(50);  // should wait 50ms for update the data
}

#define AVG_N  4

// ノイズ除去：移動平均フィルタ
// 割る数を大きくするとノイズ除去効果大
float lpf_avg(float d) {
  static float x[AVG_N], y;

  x[0] = d; // 現在の値をx[0]に
  // 平均を計算する
  for (int i=0; i<AVG_N; i++) {
    y += x[i];
  }
  y /= AVG_N;

  // 取得した値を移動させる
  // x[1] = x[0], x[2] = x[1], ..., x[N-1] = x[N-2]
  for (int i=AVG_N-1; i>0; i--) {
    x[i] = x[i-1];
  }

  return y;
}

