// Example0404 - 距離に応じてLEDを点灯
const int LED_R_PIN = 4; // LED赤のピン
const int LED_G_PIN = 3; // LED緑のピン
const int LED_Y_PIN = 13; // LED黄のピン
unsigned long dist_time = 0; // 距離センサ用のタイマー

void setup() {
  Serial.begin(38400); // bps for bluetooth communication
  Serial.flush(); // flush serial buffer
  pinMode(LED_R_PIN, OUTPUT); // LED赤 出力ポート
  pinMode(LED_G_PIN, OUTPUT); // LED緑 出力ポート
  pinMode(LED_Y_PIN, OUTPUT); // LED黄 出力ポート
}

void loop() {
  static int d;
  if (millis() - dist_time > 50) { // 50ms毎に距離計測
    d = dist_sensor();
    dist_time = millis();
  }

  if (d >= 0 && d < 100) {     // 0mm以上 100mm未満
    digitalWrite(LED_R_PIN, LOW); 
    digitalWrite(LED_G_PIN, LOW);
    digitalWrite(LED_Y_PIN, HIGH);  // 黄点灯
  } else if (d >= 100 && d < 200) { // 100mm以上 200mm未満
    digitalWrite(LED_R_PIN, LOW);     
    digitalWrite(LED_G_PIN, HIGH); // 緑点灯    
    digitalWrite(LED_Y_PIN, LOW);     
  } else if (d >= 200) {  // 200mm以上
    digitalWrite(LED_R_PIN, HIGH); // 赤点灯     
    digitalWrite(LED_G_PIN, LOW);     
    digitalWrite(LED_Y_PIN, LOW);
  } else { // それ以外
    digitalWrite(LED_R_PIN, LOW);
    digitalWrite(LED_G_PIN, LOW);  
    digitalWrite(LED_Y_PIN, LOW);     
  }
}

int dist_sensor() {
  int sensorValue = analogRead(A3); // read value from distance sensor
  double dist = 322549.9 * pow(sensorValue, -1.25356); // calcurate distance [mm]
  return dist;
}

