// Example0405 - led_on関数を追加
const int LED_R_PIN = 4; // LED赤のピン
const int LED_G_PIN = 3; // LED緑のピン
const int LED_Y_PIN = 13; // LED黄のピン
unsigned long dist_time = 0; // 距離センサ用のタイマー

void setup() {
  Serial.begin(38400); // bps for bluetooth communication
  Serial.flush(); // flush serial buffer
  pinMode(LED_R_PIN, OUTPUT); // LED赤 出力ポート
  pinMode(LED_G_PIN, OUTPUT); // LED緑 出力ポート
  pinMode(LED_Y_PIN, OUTPUT); // LED黄 出力ポート
}

void loop() {
  static int d;
  if (millis() - dist_time > 50) { // 50ms毎に距離計測
    d = dist_sensor();
    dist_time = millis();
  }

  if (d >= 0 && d < 100) {     // 0mm以上 100mm未満
     led_on(0,0,1);
  } else if (d >= 100 && d < 200) { // 100mm以上 200mm未満
     led_on(0,1,0);
  } else if (d >= 200) {  // 200mm以上
     led_on(1,0,0);
  } else { // それ以外
     led_on(0,0,0);
  }
}

void led_on(bool r, bool g, bool y) {
  digitalWrite(LED_R_PIN, r);
  digitalWrite(LED_G_PIN, g);
  digitalWrite(LED_Y_PIN, y);
}

int dist_sensor() {
  int sensorValue = analogRead(A3); // read value from distance sensor
  double dist = 322549.9 * pow(sensorValue, -1.25356); // calcurate distance [mm]
  return dist;
}

