// Example0408 - スタートスイッチ
const int LED_R_PIN = 4; // LED赤のピン
const int LED_G_PIN = 3; // LED緑のピン
const int LED_Y_PIN = 13; // LED黄のピン
unsigned long dist_time = 0; // 距離センサ用のタイマー

// モーターの変数
const int MOTOR_R_CWCCW = 7;
const int MOTOR_L_CWCCW = 8;
const int MOTOR_R_PWM = 9;
const int MOTOR_L_PWM = 10;
const int sp = 100; // モーター左右のスピード: 0 - 255

// スイッチの変数
const int SW_PIN = 12;

void setup() {
  // シリアルポートの設定
  Serial.begin(38400); // bps for bluetooth communication
  Serial.flush(); // flush serial buffer

  // LEDのポート設定
  pinMode(LED_R_PIN, OUTPUT);
  pinMode(LED_G_PIN, OUTPUT);
  pinMode(LED_Y_PIN, OUTPUT);

  // モータのポート設定
  pinMode(MOTOR_L_CWCCW, OUTPUT);
  pinMode(MOTOR_R_CWCCW, OUTPUT);

  // スイッチが押されるまで待機
  while (digitalRead(SW_PIN) == HIGH);
}

void loop() {
  static int d;
  if (millis() - dist_time > 50) {
    d = dist_sensor();
    dist_time = millis();
  }

  if (d >= 0 && d < 100) {     // 0mm以上 100mm未満
     led_on(1,0,0);
     bwd(1);
  } else if (d >= 100 && d < 200) { // 100mm以上 200mm未満
     led_on(0,1,0);
     stp(1);
  } else if (d >= 200) {  // 200mm以上
     led_on(0,0,1);
     fwd(1);
  } else { // それ以外
     led_on(0,0,0);
     stp(1);
  }
}

void led_on(bool r, bool g, bool y) {
  digitalWrite(LED_R_PIN, r);
  digitalWrite(LED_G_PIN, g);
  digitalWrite(LED_Y_PIN, y);
}

//===========================================
// 距離センサの関数
//===========================================
int dist_sensor() {
  int sensorValue = analogRead(A3); // read value from distance sensor
  double dist = 322549.9 * pow(sensorValue, -1.25356); // calcurate distance [mm]
  return dist;
}

//===========================================
// モーターの関数
//===========================================
void motor(int left, int right, int left_c, int right_c) {
  if (left_c == LOW) {
    digitalWrite(MOTOR_L_CWCCW, LOW);
  } else {
    digitalWrite(MOTOR_L_CWCCW, HIGH);
  }
  if (right_c == LOW) {
    digitalWrite(MOTOR_R_CWCCW, LOW);
  } else {
    digitalWrite(MOTOR_R_CWCCW, HIGH);
  }
  analogWrite(MOTOR_L_PWM, right); // PWM出力
  analogWrite(MOTOR_R_PWM, left); // PWM出力
}

void fwd(float cm) {
  motor(sp, sp, LOW, LOW);
  int tau = 2500.0 * cm / 20.0;
  delay(tau);
}

void bwd(float cm) {
  motor(sp, sp, HIGH, HIGH);
  int tau = 2500.0 * cm / 20.0;
  delay(tau);
}

void stp(int tau) {
  motor(0, 0, LOW, LOW);
  delay(tau);
}

void rotL(float deg) {
  motor(sp, sp, HIGH, LOW);
  int tau = 3780.0 * deg / 360.0;
  delay(tau);
}

void rotR(float deg) {
  motor(sp, sp, LOW, HIGH);
  int tau = 3820.0 * deg / 360.0;
  delay(tau);
}

