// Example0604 距離センサで取得した距離dに応じてLEDの点滅周期を変える
// LEDの変数
const int LED_R_PIN = 4;
const int LED_G_PIN = 3;
const int LED_Y_PIN = 13;
unsigned long led_r_time = 0; // LED_R用のタイマー
unsigned long led_g_time = 0; // LED_G用のタイマー
unsigned long led_y_time = 0; // LED_Y用のタイマー
bool led_r = HIGH;
bool led_g = HIGH;
bool led_y = HIGH;

// 距離センサの変数
int d; // 距離センサの計測値[mm]
unsigned long dist_time = 0; // 距離センサ用のタイマー

void setup() {
  // シリアルの設定
  Serial.begin(38400);
  Serial.flush();

  // LEDの設定
  pinMode(LED_R_PIN, OUTPUT);
  pinMode(LED_G_PIN, OUTPUT);
  pinMode(LED_Y_PIN, OUTPUT);
}

void loop() {
  if (millis() - dist_time > 50) { // 現在の時間-前の時間：50ミリ秒毎に距離取得
    d = dist_sensor(); // 距離取得
    Serial.println(100);
    dist_time = millis(); // 前の時間記憶
  }
  Serial.println(0);

  if (millis() - led_r_time > d) { // 距離に応じて点滅周期を変える
    led_r = !led_r; // HIGH->LOW, LOW-HIGH を繰り返し
    digitalWrite(LED_R_PIN, led_r);
    led_r_time = millis(); // 前の時間を記憶
  }

  if (millis() - led_g_time > 800) { // 800ミリ秒経過したら
    led_g = !led_g; // HIGH->LOW, LOW-HIGH を繰り返し
    digitalWrite(LED_G_PIN, led_g);
    led_g_time = millis(); // 前の時間を記憶
  }

  if (millis() - led_y_time > 1000) { // 1秒経過したら
    led_y = !led_y; // HIGH->LOW, LOW-HIGH を繰り返し
    digitalWrite(LED_Y_PIN, led_y);
    led_y_time = millis(); // 前の時間を記憶
  }
}

//===========================================
// 距離センサの関数
//===========================================
int dist_sensor() {
  int sensorValue = analogRead(A3); // read value from distance sensor
  double dist = 322549.9 * pow(sensorValue, -1.25356); // calcurate distance [mm]
  return dist;
}

