// Example0605 ボタンを押して，5秒間，手動でラインの上，外をフォトリフレクタが通過するよう動かす

// スイッチの変数
const int SW_PIN = 12;

// フォトリフレクタの変数
#define PR_NUM   3 // フォトリフレクタの数
int pr_pins[PR_NUM] = {A2, A1, A0}; // フォトリフレクタのピン(左，中，右)
int pr[PR_NUM]; // フォトリフレクタの値
int pr_bin[PR_NUM]; // フォトリフレクタの値(2値化後)
int pr_min[PR_NUM], pr_max[PR_NUM]; // フォトリフレクタの最小値，最大値

void setup() {
  // シリアルポートの設定
  Serial.begin(38400); // bps for bluetooth communication
  Serial.flush(); // flush serial buffer

  // スイッチが押されるまで待つ
  while (digitalRead(SW_PIN) == HIGH);

  // 校正開始
  Serial.println("start finding min, max of the photo reflectors:");
  pr_calib(); // 校正
}

void loop() {
}

void pr_minmax() {
  // pr_pins[0]=A2, pr_pins[1]=A1, pr_pins[2]=A0の順にフォトリフレクタの値を読み込み
  // 各センサの最小値，最大値を調べる
  for (int i = 0; i < PR_NUM; i++) {
    pr[i] = analogRead(pr_pins[i]); // センサの値取得
    if (pr[i] < pr_min[i]) pr_min[i] = pr[i]; // 最小値の更新
    if (pr[i] > pr_max[i]) pr_max[i] = pr[i]; // 最大値の更新
  }
}

int pr_calib() {
  for (int i = 0; i < PR_NUM; i++) { // 最小値，最大値の初期化
    pr_min[i] = 1023; // 最小値として最大値をセット
    pr_max[i] = 0;    // 最大値として最小値をセット
  }

  for (int n = 0; n < 500; n++) { // 500 * 10ms = 5秒間 最小，最大を手動で探す
    pr_minmax(); // 最小値，最大値を更新
    delay(10);
  }

  pr_print_minmax(); // 最小値，最大値の表示
}

void pr_print_minmax() {
  Serial.println("L, C, R");
  for (int i = 0; i < 3; i++) {
    Serial.print(pr_min[i]);
    Serial.print(",");
  }
  Serial.println("minimum");

  for (int i = 0; i < 3; i++) {
    Serial.print(pr_max[i]);
    Serial.print(",");
  }
  Serial.println("maximum");
}

