// Example0701: Example0408を変更
const int LED_R_PIN = 4; // LED赤のピン
const int LED_G_PIN = 3; // LED緑のピン
const int LED_Y_PIN = 13; // LED黄のピン

// 距離センサの変数
unsigned long dist_time = 0; // 距離センサ用のタイマー
int d; // 計測距離 [mm] (0mm - 200mm)
int d_t = 100; // 目標の距離 [mm]
#define KP  0.1 // KP * (d_t - d)

// モーターの変数
const int MOTOR_R_CWCCW = 7;
const int MOTOR_L_CWCCW = 8;
const int MOTOR_R_PWM = 9;
const int MOTOR_L_PWM = 10;
#define FWD LOW
#define BWD HIGH
int sp; // モーター左右のスピード: 0 - 255

// スイッチの変数
const int SW_PIN = 12;

void setup() {
  // シリアルポートの設定
  Serial.begin(38400); // bps for bluetooth communication
  Serial.flush(); // flush serial buffer

  // LEDのポート設定
  pinMode(LED_R_PIN, OUTPUT);
  pinMode(LED_G_PIN, OUTPUT);
  pinMode(LED_Y_PIN, OUTPUT);

  // モータのポート設定
  pinMode(MOTOR_L_CWCCW, OUTPUT);
  pinMode(MOTOR_R_CWCCW, OUTPUT);

  // スイッチが押されるまで待機
  while (digitalRead(SW_PIN) == HIGH);
}

void loop() {
  if (millis() - dist_time > 50) { // 距離センサで計測：50ミリ秒毎
    d = dist_sensor(); // 距離センサの値を更新
    if (d > 200) d = 200; // 距離 0mm～200mmの範囲
    dist_time = millis();
  }

  sp = KP * (d_t - d); // モーターの速度

  // モーターの速度が最大値，最小値を超える場合
  if (sp >  255) sp = 255;
  if (sp < -255) sp = -255;

  Serial.println(sp);

  // ロボットの前進，後退
  if (sp > 0) { // 近づく
    led_on(1, 0, 0); // LED赤
    motor(sp, sp, BWD, BWD); // 後退
  } else if (sp == 0) { // 一致
    led_on(1, 1, 0); // LED赤，緑
    motor(sp, sp, FWD, FWD);
  } else { // 遠ざかる
    led_on(0, 1, 0); // LED緑
    sp = abs(sp); // sp < 0, マイナスのため絶対値をとる
    motor(sp, sp, FWD, FWD); // 前進
  }
}

void led_on(bool r, bool g, bool y) {
  digitalWrite(LED_R_PIN, r);
  digitalWrite(LED_G_PIN, g);
  digitalWrite(LED_Y_PIN, y);
}

//===========================================
// 距離センサの関数
//===========================================
int dist_sensor() {
  int sensorValue = analogRead(A3); // read value from distance sensor
  double dist = 322549.9 * pow(sensorValue, -1.25356); // calcurate distance [mm]
  return dist;
}

//===========================================
// モーターの関数
//===========================================
void motor(int left, int right, int left_c, int right_c) {
  if (left_c == LOW) {
    digitalWrite(MOTOR_L_CWCCW, LOW);
  } else {
    digitalWrite(MOTOR_L_CWCCW, HIGH);
  }
  if (right_c == LOW) {
    digitalWrite(MOTOR_R_CWCCW, LOW);
  } else {
    digitalWrite(MOTOR_R_CWCCW, HIGH);
  }
  analogWrite(MOTOR_L_PWM, right); // PWM出力
  analogWrite(MOTOR_R_PWM, left); // PWM出力
}

