// Example0702 センサの反応(100,010,001,000)に応じてモーターの速度を変える
const int LED_R_PIN = 4; // LED赤のピン
const int LED_G_PIN = 3; // LED緑のピン
const int LED_Y_PIN = 13; // LED黄のピン

// モーターの変数
const int MOTOR_R_CWCCW = 7;
const int MOTOR_L_CWCCW = 8;
const int MOTOR_R_PWM   = 9;
const int MOTOR_L_PWM   = 10;
#define FWD  LOW
#define BKW  HIGH
const int sp = 100; // モーターの基本速度: 0 - 255
int sp_diff = 20; // モーターの旋回量: 0-100(sp)
int motor_l; // 左モーターの速度
int motor_r; // 右モーターの速度
unsigned long motor_time = 0; // モーター用のタイマー

// フォトリフレクタの変数
#define PR_NUM  3
int pr_pins[PR_NUM] = {A2, A1, A0};
int pr[PR_NUM];
int pr_nrm[PR_NUM]; // 正規化後のフォトリフレクタの値0-100
int pr_bin[PR_NUM]; // フォトリフレクタの値(2値化後)
//int pr_min[PR_NUM], pr_max[PR_NUM]; // フォトリフレクタの最小値，最大値
int  pr_min[PR_NUM] = {457, 414, 614}; // 自動校正した最小値を貼り付け(Example0606)
int  pr_max[PR_NUM] = {950, 841, 996}; // 自動校正した最大値を貼り付け(Example0606)
unsigned long pr_time = 0; // フォトリフレクタ用のタイマー

// スイッチの変数
const int SW_PIN = 12;

void setup() {
  // シリアルポートの設定
  Serial.begin(38400); // bps for bluetooth communication
  Serial.flush(); // flush serial buffer

  // LEDのポート設定
  pinMode(LED_R_PIN, OUTPUT);
  pinMode(LED_G_PIN, OUTPUT);
  pinMode(LED_Y_PIN, OUTPUT);

  // モータのポート設定
  pinMode(MOTOR_L_CWCCW, OUTPUT);
  pinMode(MOTOR_R_CWCCW, OUTPUT);

  // スイッチが押されるまで待機
  while (digitalRead(SW_PIN) == HIGH);

  // フォトリフレクタの校正
  //pr_calib();
}

void loop() {
  // フォトリフレクタのセンサ値更新 50ミリ秒毎
  if (millis() - pr_time > 50) {
    pr_sensor();
    pr_time = millis();
  }

  // フォトリフレクタの位置に応じたモーターの制御量調整
  if (pr_bin[0] == 1 && pr_bin[1] == 0 && pr_bin[2] == 0) { // 100, 右旋回
    motor_l = -sp_diff;
    motor_r = sp_diff;
  } else if (pr_bin[0] == 0 && pr_bin[1] == 1 && pr_bin[2] == 0) { // 010, 直進
    motor_l = 0;
    motor_r = 0;
  } else if (pr_bin[0] == 0 && pr_bin[1] == 0 && pr_bin[2] == 1) { // 001, 左旋回
    motor_l = sp_diff;
    motor_r = -sp_diff;
  } else if (pr_bin[0] == 0 && pr_bin[1] == 0 && pr_bin[2] == 0) { // 000, 左旋回(とりあえず)
    motor_l = sp_diff;
    motor_r = -sp_diff;
  } else { // どれにもあてはまならい(直進)
    motor_l = 0;
    motor_r = 0;
  }

  motor_l += sp; // 基本スピードを足す
  motor_r += sp; // 基本スピードを足す

  // モーターの速度の最大値，最小値を超えていないか確認
  if (motor_l > 255) motor_l = 255;
  if (motor_r > 255) motor_r = 255;
  if (motor_l < 0) motor_l = 0;
  if (motor_r < 0) motor_r = 0;

  // モーター速度の設定
  motor(motor_l, motor_r, FWD, FWD);

  //Serial.print(motor_l); Serial.print(",");
  //Serial.println(motor_r);
}

//===========================================
// フォトリフレクタの関数
//===========================================
// フォトリフレクタのセンサ値 pr[]: 0-1023
// フォトリフレクタの正規化値 pr_nrm[]: 0-100
// フォトリフレクタの2値化 pr_bin[]: 0, 1
void pr_sensor() {
  for (int i = 0; i < PR_NUM; i++) {
    pr[i] = analogRead(pr_pins[i]);
    if (pr[i] < pr_min[i]) pr_min[i] = pr[i];
    if (pr[i] > pr_max[i]) pr_max[i] = pr[i];
    pr_nrm[i] = 100.0 * (pr[i] - pr_min[i]) / (pr_max[i] - pr_min[i]);
    if (pr_nrm[i] > 50) pr_bin[i] = 1;
    else pr_bin[i] = 0;
  }
}

// 各フォトリフレクタの最小，最大値
void pr_minmax() {
  for (int i = 0; i < PR_NUM; i++) {
    pr[i] = analogRead(pr_pins[i]);
    if (pr[i] < pr_min[i]) pr_min[i] = pr[i];
    if (pr[i] > pr_max[i]) pr_max[i] = pr[i];
  }
}

// フォトリフレクタ校正
void pr_calib() {
  for (int i = 0; i < PR_NUM; i++) {
    pr_min[i] = 1023;
    pr_max[i] = 0;
  }
  for (int i = 0; i < 80; i++) {
    if ( (i > 10 && i <= 30) || (i > 50 && i <= 70) ) {
      motor(150, 150, FWD, BKW);
    } else {
      motor(150, 150, BKW, FWD);
    }
    pr_minmax();
    delay(40);
  }
  motor(0, 0, FWD, FWD);
}

//===========================================
// モーターの関数
//===========================================
void motor(int left, int right, int left_c, int right_c) {
  if (left_c == FWD) {
    digitalWrite(MOTOR_L_CWCCW, FWD);
  } else {
    digitalWrite(MOTOR_L_CWCCW, BKW);
  }
  if (right_c == FWD) {
    digitalWrite(MOTOR_R_CWCCW, FWD);
  } else {
    digitalWrite(MOTOR_R_CWCCW, BKW);
  }
  analogWrite(MOTOR_L_PWM, left); // PWM出力
  analogWrite(MOTOR_R_PWM, right); // PWM出力
}

