/*
 * Decompiled with CFR 0.152.
 */
package com.elsevier.scival;

import com.elsevier.scival.SciValCSV;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import jp.ac.tokushima_u.db.common.PgRDB;
import jp.ac.tokushima_u.db.common.TextUtility;
import jp.ac.tokushima_u.db.logistics.ExtRDB;
import jp.ac.tokushima_u.db.logistics.ExtRDBCluster;
import jp.ac.tokushima_u.db.logistics.Logistics;
import jp.ac.tokushima_u.db.logistics.Scopus;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class SciValAffiliationAuthors
extends SciValCSV {
    public static final String cn_Name = "Name";
    public static final String cn_Scholarly_Output = "Scholarly Output";
    public static final String cn_Most_recent_publication = "Most recent publication";
    public static final String cn_Scopus_author_ID = "Scopus author ID";
    static final String cn_Scopus_author_profile = "Scopus author profile";
    static Set<String> s_omit_columns = new HashSet<String>(Arrays.asList("Scopus author profile"));
    String affiliation_name = "";
    public static PgRDB.Column extrdb_c_affname = new PgRDB.Column("affname");
    public static ExtRDB.ExtRDBColumn extrdb_c_auid = new ExtRDB.ExtRDBColumn("auid", (Logistics.IdHandler)Scopus.auidHandler);
    public static PgRDB.Column extrdb_c_name = new PgRDB.Column("name");
    public static PgRDB.Column extrdb_c_value = new PgRDB.Column("value");
    public static ExtRDB.ExtRDBTable extrdb_t_affiliation_author = new ExtRDB.ExtRDBTable("scival_affiliation_author", new PgRDB.Column[]{extrdb_c_affname.notNull(), extrdb_c_auid.notNull(), extrdb_c_name.notNull(), extrdb_c_value});

    public String getAffiliationName() {
        return this.affiliation_name;
    }

    public SciValAffiliationAuthors(File file, PrintWriter err) {
        super(file, "\"Name\",\"Scholarly Output\",", "\"\",\"\",\"\",\"\",", true, err);
        for (String line : this.head_part) {
            int idx;
            if (!TextUtility.textIsValid((CharSequence)line) || !line.startsWith("\"Entity\",")) continue;
            this.affiliation_name = line.substring("\"Entity\",".length());
            if (this.affiliation_name.startsWith("\"")) {
                this.affiliation_name = this.affiliation_name.substring(1);
            }
            if ((idx = this.affiliation_name.indexOf("\"")) <= 0) continue;
            this.affiliation_name = this.affiliation_name.substring(0, idx);
        }
    }

    public int forEachRecord(Consumer<CSVRecord> callback, PrintWriter err) {
        int num;
        block15: {
            num = 0;
            try (CSVParser parser = this.createCSVParser();){
                for (CSVRecord rec : parser) {
                    callback.accept(rec);
                    ++num;
                }
            }
            catch (IOException ex) {
                if (err == null) break block15;
                err.println(ex);
            }
        }
        return num;
    }

    public void propagateToExtRDB(CSVRecord rec, PrintWriter err) {
        SciValAffiliationAuthors.extrdbUpdate(this.affiliation_name, rec, s_omit_columns, this.lastModified);
    }

    public static void extrdbCreateTable(ExtRDBCluster<ExtRDB> cluster, boolean renew) {
        if (extrdb_t_affiliation_author.create(cluster, renew)) {
            extrdb_t_affiliation_author.setReplicaIdentity(extrdb_t_affiliation_author.createIndex(true, new PgRDB.Column[]{extrdb_c_affname, extrdb_c_auid, ExtRDB.c_age}));
            extrdb_t_affiliation_author.createIndex(false, new PgRDB.Column[]{extrdb_c_affname, extrdb_c_auid});
            extrdb_t_affiliation_author.createIndex(extrdb_c_affname, false);
            extrdb_t_affiliation_author.createIndex((PgRDB.Column)extrdb_c_auid, false);
            extrdb_t_affiliation_author.createIndex(extrdb_c_name, false);
        }
    }

    public static void extrdbUpdate(String affiliation_name, CSVRecord rec, Set<String> s_omits, long lastModified) {
        if (!TextUtility.textIsValid((CharSequence)affiliation_name)) {
            return;
        }
        String auid = rec.get(cn_Scopus_author_ID);
        if (!TextUtility.textIsValid((CharSequence)auid)) {
            return;
        }
        ArrayList cvss = new ArrayList();
        ArrayList<PgRDB.Value> cvs0 = new ArrayList<PgRDB.Value>();
        cvs0.add(extrdb_c_affname.createValue(affiliation_name));
        cvs0.add(extrdb_c_auid.createValue(auid));
        for (String cn : rec.getParser().getHeaderNames()) {
            if (!TextUtility.textIsValid((CharSequence)cn) || s_omits != null && s_omits.contains(cn)) continue;
            ArrayList<PgRDB.Value> cvs = new ArrayList<PgRDB.Value>(cvs0);
            cvs.add(extrdb_c_name.createValue(cn));
            cvs.add(extrdb_c_value.createValue(rec.get(cn)));
            cvss.add(cvs);
        }
        extrdb_t_affiliation_author.deleteAndMultipleInsert(lastModified, new PgRDB.Where(new PgRDB.SQLText[]{extrdb_c_affname.eq(affiliation_name), extrdb_c_auid.eq(auid)}), cvss);
    }

    public static void extrdbDelete(String affiliation_name, Scopus.ScopusAuId auid, long lastModified) {
        if (!TextUtility.textIsValid((CharSequence)affiliation_name)) {
            return;
        }
        if (!Logistics.isValid((Logistics.Id)auid)) {
            return;
        }
        extrdb_t_affiliation_author.delete(new PgRDB.Where(new PgRDB.SQLText[]{extrdb_c_affname.eq(affiliation_name), extrdb_c_auid.eq((Logistics.Id)auid)}));
    }

    public static void extrdbFlush() {
        extrdb_t_affiliation_author.flush();
    }
}

