/*
 * Decompiled with CFR 0.152.
 */
package com.elsevier.scival;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import jp.ac.tokushima_u.db.common.IOUtility;
import jp.ac.tokushima_u.db.common.TextUtility;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class SciValCSV {
    ArrayList<String> head_part;
    StringBuilder csv_part;
    int csv_part_lines;
    ArrayList<String> tail_part;
    long lastModified;

    SciValCSV(File file, String csv_start, String csv_end, boolean escape_dquote, PrintWriter err) {
        block20: {
            this.head_part = new ArrayList();
            this.csv_part = new StringBuilder();
            this.csv_part_lines = 0;
            this.tail_part = new ArrayList();
            this.lastModified = file.lastModified();
            try (BufferedReader rdr = new BufferedReader(IOUtility.openReader((File)file));){
                String line;
                while ((line = rdr.readLine()) != null) {
                    if (line.startsWith(csv_start)) {
                        this.csv_part.append(line).append("\n");
                        ++this.csv_part_lines;
                        break;
                    }
                    this.head_part.add(line);
                }
                while ((line = rdr.readLine()) != null && (csv_end == null || !line.startsWith(csv_end)) && TextUtility.textIsValid((CharSequence)line)) {
                    this.csv_part.append(escape_dquote ? line.replaceAll("\\\\\"", "") : line).append("\n");
                    ++this.csv_part_lines;
                }
                while ((line = rdr.readLine()) != null) {
                    if (!line.startsWith("\"\u00a9 ") && err != null) {
                        err.println("\t" + line);
                    }
                    this.tail_part.add(line);
                }
            }
            catch (IOException ex) {
                if (err == null) break block20;
                err.println(ex);
            }
        }
    }

    public int getNumberOfCSVLines() {
        return this.csv_part_lines - 1;
    }

    CSVParser createCSVParser() throws IOException {
        return new CSVParser((Reader)new StringReader(this.csv_part.toString()), CSVFormat.DEFAULT.withFirstRecordAsHeader());
    }

    public static String getRecText(CSVRecord rec, String cn, String dv) {
        String v = rec.get(cn);
        if (TextUtility.textIsValid((CharSequence)v) && !"-".equals(v)) {
            return v;
        }
        return dv;
    }

    public static int getRecInteger(CSVRecord rec, String cn, int dv) {
        String v = rec.get(cn);
        if (TextUtility.textIsValid((CharSequence)v) && !"-".equals(v) && TextUtility.textIsInteger((CharSequence)v)) {
            return TextUtility.textToInteger((CharSequence)v);
        }
        return dv;
    }

    public static double getRecReal(CSVRecord rec, String cn, double dv) {
        String v = rec.get(cn);
        if (TextUtility.textIsValid((CharSequence)v) && !"-".equals(v) && TextUtility.textIsReal((CharSequence)v)) {
            return TextUtility.textToReal((CharSequence)v);
        }
        return dv;
    }
}

