/*
 * Decompiled with CFR 0.152.
 */
package com.elsevier.scival;

import com.elsevier.scival.SciValCSV;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import jp.ac.tokushima_u.db.common.PgRDB;
import jp.ac.tokushima_u.db.common.TextUtility;
import jp.ac.tokushima_u.db.logistics.ExtRDB;
import jp.ac.tokushima_u.db.logistics.ExtRDBCluster;
import jp.ac.tokushima_u.db.logistics.Logistics;
import jp.ac.tokushima_u.db.logistics.Scopus;
import jp.ac.tokushima_u.db.utlf.content.UDate;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class SciValPublications
extends SciValCSV {
    public static final String cn_Year = "Year";
    public static final String cn_Full_date = "Full date";
    public static final String cn_SNIP = "SNIP (publication year)";
    public static final String cn_CiteScore = "CiteScore (publication year)";
    public static final String cn_CiteScore_percentile = "CiteScore percentile (publication year) *";
    public static final String cn_Citations = "Citations";
    public static final String cn_FWCI = "Field-Weighted Citation Impact";
    public static final String cn_FWO_TCP = "Field-Weighted Outputs in Top Citation Percentiles, per percentile";
    static final String cn_Reference = "Reference";
    static final String cn_Abstract = "Abstract";
    public static final String cn_EID = "EID";
    public static final String cn_Topic_Cluster_name = "Topic Cluster name";
    public static final String cn_Topic_Cluster_number = "Topic Cluster number";
    public static final String cn_Topic_Cluster_Prominence_Percentile = "Topic Cluster Prominence Percentile";
    public static final String cn_Topic_name = "Topic name";
    public static final String cn_Topic_number = "Topic number";
    public static final String cn_Topic_Prominence_Percentile = "Topic Prominence Percentile";
    public static final String cn_Topic_strength = "Publication link to Topic strength";
    static Set<String> s_omit_columns = new HashSet<String>(Arrays.asList("Reference", "Abstract"));
    public static ExtRDB.ExtRDBColumn extrdb_c_eid = new ExtRDB.ExtRDBColumn("eid", (Logistics.IdHandler)Scopus.eidHandler);
    public static PgRDB.Column extrdb_c_name = new PgRDB.Column("name");
    public static PgRDB.Column extrdb_c_value = new PgRDB.Column("value");
    public static ExtRDB.ExtRDBTable extrdb_t_publication = new ExtRDB.ExtRDBTable("scival_publication", new PgRDB.Column[]{extrdb_c_eid.notNull(), extrdb_c_name.notNull(), extrdb_c_value});

    public SciValPublications(File file, PrintWriter err) {
        super(file, "\"Title\",\"Authors\",", null, false, err);
    }

    public int forEachRecord(Consumer<CSVRecord> callback, PrintWriter err) {
        int num;
        block16: {
            if (!TextUtility.textIsValid((CharSequence)this.csv_part)) {
                return 0;
            }
            num = 0;
            try (CSVParser parser = this.createCSVParser();){
                for (CSVRecord rec : parser) {
                    callback.accept(rec);
                    ++num;
                }
            }
            catch (IOException ex) {
                if (err == null) break block16;
                err.println(ex);
            }
        }
        return num;
    }

    public void propagateToExtRDB(CSVRecord rec, PrintWriter err) {
        SciValPublications.extrdbUpdate(rec, s_omit_columns, this.lastModified);
    }

    public static void extrdbCreateTable(ExtRDBCluster<ExtRDB> cluster, boolean renew) {
        if (extrdb_t_publication.create(cluster, renew)) {
            extrdb_t_publication.setReplicaIdentity(extrdb_t_publication.createIndex(true, new PgRDB.Column[]{extrdb_c_eid, ExtRDB.c_age}));
            extrdb_t_publication.createIndex((PgRDB.Column)extrdb_c_eid, false);
            extrdb_t_publication.createIndex(extrdb_c_name, false);
        }
    }

    public static void extrdbUpdate(CSVRecord rec, Set<String> s_omits, long lastModified) {
        String v = rec.get(cn_EID);
        if (!TextUtility.textIsValid((CharSequence)v)) {
            return;
        }
        Scopus.ScopusArticleId scopusId = new Scopus.ScopusArticleId(v);
        if (!Logistics.isValid((Logistics.Id)scopusId)) {
            return;
        }
        ArrayList cvss = new ArrayList();
        ArrayList<PgRDB.Value> cvs0 = new ArrayList<PgRDB.Value>();
        cvs0.add(extrdb_c_eid.createValue((Logistics.Id)scopusId));
        for (String cn : rec.getParser().getHeaderNames()) {
            if (!TextUtility.textIsValid((CharSequence)cn) || s_omits != null && s_omits.contains(cn)) continue;
            ArrayList<PgRDB.Value> cvs = new ArrayList<PgRDB.Value>(cvs0);
            cvs.add(extrdb_c_name.createValue(cn));
            cvs.add(extrdb_c_value.createValue(rec.get(cn)));
            cvss.add(cvs);
        }
        extrdb_t_publication.deleteAndMultipleInsert(lastModified, new PgRDB.Where(new PgRDB.SQLText[]{extrdb_c_eid.eq((Logistics.Id)scopusId)}), cvss);
    }

    public static void extrdbDelete(Scopus.ScopusArticleId eid, long lastModified) {
        if (!Logistics.isValid((Logistics.Id)eid)) {
            return;
        }
        extrdb_t_publication.delete(new PgRDB.Where(new PgRDB.SQLText[]{extrdb_c_eid.eq((Logistics.Id)eid)}));
    }

    public static void extrdbFlush() {
        extrdb_t_publication.flush();
    }

    public static PublicationInfo extrdbRetrievePublicationInfo(Scopus.ScopusArticleId scopusid) {
        if (!Logistics.isValid((Logistics.Id)scopusid)) {
            return null;
        }
        PublicationInfo pi = null;
        try {
            List list = Logistics.extrdbCluster.select(new PgRDB.SQLPhrase[]{new PgRDB.Fields(new PgRDB.SQLText[]{ExtRDB.c_age, extrdb_c_eid, extrdb_c_name, extrdb_c_value}), new PgRDB.From(new PgRDB.Table[]{extrdb_t_publication.getTable()}), new PgRDB.Where(new PgRDB.SQLText[]{extrdb_c_eid.eq(scopusid.getLocalId(1))}), new PgRDB.OrderBy(new PgRDB.Column[]{ExtRDB.c_age})});
            if (list != null && !list.isEmpty()) {
                pi = new PublicationInfo(scopusid, TextUtility.textToLong((CharSequence)((CharSequence)((List)list.get(0)).get(0))));
                for (List rec : list) {
                    pi.set((String)rec.get(2), (String)rec.get(3));
                }
            }
        }
        catch (SQLException ex) {
            ExtRDB.printSQLError((PrintStream)System.err, (String)"extrdbRetrievePublicationInfo.select", (SQLException)ex);
        }
        return pi;
    }

    public static class PublicationInfo
    extends ExtRDB.CommonValues {
        public long age = 0L;
        public Scopus.ScopusArticleId eid;
        public int v_year = -1;
        public UDate v_full_date = null;
        public double v_snip = -1.0;
        public double v_citescore = -1.0;
        public double v_citescore_percentile = -1.0;
        public int v_citations = -1;
        public double v_fwci = -1.0;
        public double v_fwo_tcp = -1.0;
        public String v_topic_cluster_name = null;
        public String v_topic_cluster_number = null;
        public double v_topic_cluster_prominence_percentile = -1.0;
        public String v_topic_name = null;
        public String v_topic_number = null;
        public double v_topic_prominence_percentile = -1.0;
        public String v_topic_strength = null;

        public Scopus.ScopusArticleId getScopusArticleId() {
            return this.eid;
        }

        PublicationInfo(Scopus.ScopusArticleId e, long a) {
            this.eid = e;
            this.age = a;
        }

        void set(String cn, String v) {
            if (!TextUtility.textIsValid((CharSequence)cn)) {
                return;
            }
            if (!TextUtility.textIsValid((CharSequence)v) || "-".equals(v)) {
                return;
            }
            switch (cn) {
                case "Year": {
                    this.v_year = TextUtility.textToInteger((CharSequence)v, (int)this.v_year);
                    break;
                }
                case "Full date": {
                    this.v_full_date = new UDate(v);
                    break;
                }
                case "SNIP (publication year)": {
                    this.v_snip = TextUtility.textToReal((CharSequence)v, (double)this.v_snip);
                    break;
                }
                case "CiteScore (publication year)": {
                    this.v_citescore = TextUtility.textToReal((CharSequence)v, (double)this.v_citescore);
                    break;
                }
                case "CiteScore percentile (publication year) *": {
                    this.v_citescore_percentile = TextUtility.textToReal((CharSequence)v, (double)this.v_citescore_percentile);
                    break;
                }
                case "Citations": {
                    this.v_citations = TextUtility.textToInteger((CharSequence)v, (int)this.v_citations);
                    break;
                }
                case "Field-Weighted Citation Impact": {
                    this.v_fwci = TextUtility.textToReal((CharSequence)v, (double)this.v_fwci);
                    break;
                }
                case "Field-Weighted Outputs in Top Citation Percentiles, per percentile": {
                    this.v_fwo_tcp = TextUtility.textToReal((CharSequence)v, (double)this.v_fwo_tcp);
                    break;
                }
                case "EID": {
                    break;
                }
                case "Topic Cluster name": {
                    this.v_topic_cluster_name = v;
                    break;
                }
                case "Topic Cluster number": {
                    this.v_topic_cluster_number = v;
                    break;
                }
                case "Topic Cluster Prominence Percentile": {
                    this.v_topic_cluster_prominence_percentile = TextUtility.textToReal((CharSequence)v, (double)this.v_topic_cluster_prominence_percentile);
                    break;
                }
                case "Topic name": {
                    this.v_topic_name = v;
                    break;
                }
                case "Topic number": {
                    this.v_topic_number = v;
                    break;
                }
                case "Topic Prominence Percentile": {
                    this.v_topic_prominence_percentile = TextUtility.textToReal((CharSequence)v, (double)this.v_topic_prominence_percentile);
                    break;
                }
                case "Publication link to Topic strength": {
                    this.v_topic_strength = v;
                    break;
                }
            }
        }
    }
}

